/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xsetutil.h 
 *       Helper functions for the setting database
 * -----------------------------------------------------------------*/

#ifndef XSETUTIL_H_INCLUDED
#define XSETUTIL_H_INCLUDED

#include <xpciapi.h>

/********************************************************************
  Accessing property memories ***************************************
 *******************************************************************/

bx_bool BestXMemPropSet
(
  bx_int32 *MemLine,
  bx_int32 FirstBitPos,
  bx_int32 LastBitPos,
  bx_int32 Value,
  bx_charptrtype PropName,
  bx_int32 RegSize
);

bx_bool BestXMemPropGet
(
  bx_int32 *MemLine,
  bx_int32 FirstBitPos,
  bx_int32 LastBitPos,
  bx_int32 *Value,
  bx_charptrtype PropName,
  bx_int32 RegSize
);

/********************************************************************
  Debugging *********************************************************
 *******************************************************************/

bx_bool EXPORT BestXPrintDB(bx_handletype handle,bx_charptrtype FileName);
bx_bool EXPORT BestXPrintMBlkDB(bx_handletype handle,FILE *fp,bx_charptrtype Message);
bx_bool EXPORT BestXPrintMBehDB(bx_handletype handle,FILE *fp,bx_charptrtype Message);
bx_bool EXPORT BestXPrintTBehDB(bx_handletype handle,FILE *fp,bx_charptrtype Message);
bx_bool EXPORT BestXPrintCBehDB(bx_handletype handle,FILE *fp,bx_charptrtype Message);
bx_bool EXPORT BestXPrintRBehDB(bx_handletype handle,FILE *fp,bx_charptrtype Message);
bx_bool EXPORT BestXPrintGenPropDB(bx_handletype handle,FILE *fp,bx_charptrtype Message);
bx_bool EXPORT BestXPrintConfigDB(bx_handletype handle,FILE *fp,bx_charptrtype Message);

/********************************************************************
  Misc **************************************************************
 *******************************************************************/

bx_bool BestXBitMaskModify(
  bx_int32 *Value,   
  bx_int32 FirstBitPos,
  bx_int32 LastBitPos,
  bx_int32 BitVal 
);

#endif
